.origin 0
.entrypoint START

#define PRU0_ARM_INTERRUPT 19

#define CLK_DIN      (1<< 6)
#define PL_DIN       (1<< 7)
#define DCP_DOUT     (1<< 9)
#define DS_DOUT      (1<<10)
#define SCP_DOUT     (1<<11)
#define OUT_DIN      (1<<24)

#define OUT_DIN_BIT      24

#define GPIO0 				   0x44e07000  // The adress of the GPIO0 
#define GPIO1 				   0x4804c000  // The adress of the GPIO1 
#define GPIO2 				   0x481ac000  // The adress of the GPIO2 
#define GPIO_DATAIN             0x138  // The adress offset of GPIO_DATAIN 
#define GPIO_CLEARDATAOUT 	     0x190  // The adress offset of GPIO_CLEARDATAOUT 
#define GPIO_SETDATAOUT 	     0x194  // The adress offset of GPIO_SETDATAOUT 

START:
    // PRU Initialisierung, steht so in jedem Beispiel
    lbco r0, c4, 4, 4					   // Load the config 
    clr  r0, r0, 4						   // Clear Bit 4 in config
    sbco r0, c4, 4, 4					   // Store the config

    // Wert für Ausgangs-Schieberegister in r0 laden
    // Zuerst c28 Pointer beider PRUs auf Start des Shared RAM setzen
    MOV  r0, 0x0100                    // r0 auf 0x0100 setzen.
    MOV  r1, 0x00022028                // Adresse von PRU0.CTPPR0
    SBBO r0, r1, 0, 4                  // Schreibt 0 in PRU0.CTPPR0. Somit zeigt c28 auf 0x00010000
    MOV  r1, 0x00024028                // Adresse von PRU1.CTPPR0
    SBBO r0, r1, 0, 4                  // Schreibt 0 in PRU1.CTPPR0. Somit zeigt c28 auf 0x00010000
    // Dann Inhalt von Shared RAM lesen
    LBCO r0, c28, 0, 4                 // Inhalt von SHARED RAM nach r0 kopieren (4 Byte)
    ZERO 1, 4                          // r1 auf 0 setzen, da hier das Eingangs-Schieberegister eingelesen wird.
    
    // Beide Clock auf 1
    MOV r2, CLK_DIN | DCP_DOUT         // CLK_DIN und DCP_DOUT Bit in r2 setzen
    MOV r3, GPIO2 | GPIO_SETDATAOUT    // Adresse auf GPIO2.GPIO_SETDATAOUT 
    SBBO r2, r3, 0, 4                  // r2 nach GPIO2.GPIO_SETDATAOUT schreiben. Setzt CLK_DIN und DCP_DOUT Pins auf 1
    
    // Eingangs-Schieberegister laden
    MOV r2, PL_DIN                     // PL_DIN Bit in r2 setzen
    MOV r3, GPIO2 | GPIO_CLEARDATAOUT  // Adresse auf GPIO2.GPIO_CLEARDATAOUT 
    SBBO r2, r3, 0, 4                  // r2 nach GPIO2.GPIO_CLEARDATAOUT schreiben. Setzt PL_DIN Pin auf 0

    // Etwas warten, damit der Takt nicht zu schnell wird
    MOV r5, 5
DELAY_PL_DIN:
    SUB r5, r5, 1
    QBNE DELAY_PL_DIN, r5, 0
    
    MOV r2, PL_DIN                     // PL_DIN Bit in r2 setzen
    MOV r3, GPIO2 | GPIO_SETDATAOUT    // Adresse auf GPIO2.GPIO_SETDATAOUT 
    SBBO r2, r3, 0, 4                  // r2 nach GPIO2.GPIO_SETDATAOUT schreiben. Setzt PL_DIN Pin auf 1

// START ShiftLoop
    mov  r4, 24                        // Schleifenzähler initialisieren. 1 mehr, da direkt beim Start subtrahiert wird.
    mov  r6, 0x800000
    
ShiftLoop:                             // Start der Schleife, damit das 24-Bit Ausgangs-Schieberegister vollständig geladen wird.
    sub  r4, r4, 1                     // Schleifenzähler und gleichzeitig Bit-Index um 1 verringern.

    AND r7, r0, r4                     // r7 = r0 & r4, also Wert in r0 mit Maske ver-unden
    lsr r7, 1
    //qbbs SetDout, r0, r4               // Springe nach SetDout, wenn Bit [r4] in r0 gesetzt ist.
    qbne SetDout, r0, 0               // Springe nach SetDout, wenn Bit [r4] in r0 gesetzt ist.
    MOV r2, DS_DOUT                    // ansonsten lösche DS_DOUT: DS_DOUT Bit in r2 setzen
    MOV r3, GPIO2 | GPIO_CLEARDATAOUT  // Adresse auf GPIO2.GPIO_CLEARDATAOUT 
    SBBO r2, r3, 0, 4                  // r2 nach GPIO2.GPIO_CLEARDATAOUT schreiben. Setzt DS_DOUT Pin auf 0
    jmp  GetDin                        // und springe danach zu GetDin
SetDout:
    MOV r2, DS_DOUT                    // Setze DS_DOUT: DS_DOUT Bit in r2 setzen
    MOV r3, GPIO2 | GPIO_SETDATAOUT    // Adresse auf GPIO2.GPIO_SETDATAOUT 
    SBBO r2, r3, 0, 4                  // r2 nach GPIO2.GPIO_SETDATAOUT schreiben. Setzt DS_DOUT Pin auf 1

GetDin:
    MOV r3, GPIO2 | GPIO_DATAIN        // Adresse auf GPIO2.GPIO_DATAIN 
    LBBO r2, r3, 0, 4                  // GPIO2.GPIO_SETDATAOUT nach r2 laden. Liest GPIO2
    qbbc DinNotSet, r2, OUT_DIN_BIT    // Springe nach DinNotSet, wenn OUT_DIN nicht gesetzt ist
    set  r1, r4                        // ansonsten setze Bit [r4] in r0
DinNotSet:
    
    // Etwas warten, damit der Takt nicht zu schnell wird
    MOV r5, 5
DELAY_CLK_0:
    SUB r5, r5, 1
    QBNE DELAY_CLK_0, r5, 0
    
    // Beide Clock auf 0
    MOV r2, CLK_DIN | DCP_DOUT         // CLK_DIN und DCP_DOUT Bit in r2 setzen
    MOV r3, GPIO2 | GPIO_CLEARDATAOUT  // Adresse auf GPIO2.GPIO_CLEARDATAOUT 
    SBBO r2, r3, 0, 4                  // r2 nach GPIO2.GPIO_CLEARDATAOUT schreiben. Setzt CLK_DIN und DCP_DOUT Pins auf 0

    // Etwas warten, damit der Takt nicht zu schnell wird
    MOV r5, 5
DELAY_CLK_1:
    SUB r5, r5, 1
    QBNE DELAY_CLK_1, r5, 0
    
    // Beide Clock auf 1
    MOV r2, CLK_DIN | DCP_DOUT         // CLK_DIN und DCP_DOUT Bit in r2 setzen
    MOV r3, GPIO2 | GPIO_SETDATAOUT    // Adresse auf GPIO2.GPIO_SETDATAOUT 
    SBBO r2, r3, 0, 4                  // r2 nach GPIO2.GPIO_SETDATAOUT schreiben. Setzt CLK_DIN und DCP_DOUT Pins auf 1
    
    // Etwas warten, damit der Takt nicht zu schnell wird
    MOV r5, 5
DELAY_CLK_2:
    SUB r5, r5, 1
    QBNE DELAY_CLK_2, r5, 0
    
    // Takt ist fertig, dann schauen, ob ein weiterer Schleifendurchlauf kommt
    qbne ShiftLoop, r4, 0              // Ende der Schleife, wenn r0 = 0
// ENDE ShiftLoop


    // Ausgangs-Schieberegister setzen
    MOV r2, SCP_DOUT                   // Setze SCP_DOUT: SCP_DOUT Bit in r2 setzen
    MOV r3, GPIO2 | GPIO_SETDATAOUT    // Adresse auf GPIO2.GPIO_SETDATAOUT 
    SBBO r2, r3, 0, 4                  // r2 nach GPIO2.GPIO_SETDATAOUT schreiben. Setzt SCP_DOUT Pin auf 1

    // Etwas warten, damit der Takt nicht zu schnell wird
    MOV r5, 5
DELAY_SCP_DOUT:
    SUB r5, r5, 1
    QBNE DELAY_SCP_DOUT, r5, 0
    
    MOV r2, SCP_DOUT                   // ansonsten lösche SCP_DOUT: SCP_DOUT Bit in r2 setzen
    MOV r3, GPIO2 | GPIO_CLEARDATAOUT  // Adresse auf GPIO2.GPIO_CLEARDATAOUT 
    SBBO r2, r3, 0, 4                  // r2 nach GPIO2.GPIO_CLEARDATAOUT schreiben. Setzt SCP_DOUT Pin auf 0
    
    MOV r2, PL_DIN                     // PL_DIN Bit in r2 setzen
    MOV r3, GPIO2 | GPIO_CLEARDATAOUT  // Adresse auf GPIO2.GPIO_CLEARDATAOUT 
    SBBO r2, r3, 0, 4                  // r2 nach GPIO2.GPIO_CLEARDATAOUT schreiben. Setzt PL_DIN Pin auf 0
    
    lsr  r1, r1, 8                     // Eingangs-Wert ist noch 8 Bit zu weit links
    sbco r1, c28, 0, 4                 // Inhalt von r1 nach SHARED RAM kopieren    
    
    // Interrupt setzen und PRU deaktivieren
    mov  r31.b0, PRU0_ARM_INTERRUPT+16 // Interrupt
    halt                               // PRU aus
    
